// list of characters sorted by smallest huffman encoding
$HuffFreq::String = "\x20\x61\x65\x69\x6e\x6f\x72\x74\x63\x64\x6c\x6d\x73\x75\x2e\x30\x31\x66\x67\x68\x70\x76\x77\x09\x45\x4d\x53\x54\x5f\x62\x6a\x6b\x79\x32\x33\x3c\x3e\x41\x42\x44\x47\x49\x4c\x4e\x50\x52\x59\x21\x25\x27\x2d\x3a\x46\x48\x58\x78\x7e\x23\x34\x35\x36\x38\x39\x3f\x43\x4f\x7a\x0a\x2c\x37\x4b\x55\x57\x29\x4a\x56\x26\x28\x2f\x3d\x5c\x71\x3b\x51\x5a\x02\x03\x04\x05\x06\x07\x08\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x22\x24\x2a\x2b\x40\x5b\x5d\x5e\x60\x7b\x7c\x7d\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff\x01";

function Huff::StartWrite() {
	$Huff::WriteString = "";
}

function Huff::StartRead( %str ) {
	$Huff::ReadString = %str;
	$Huff::Idx = 0;
}

$HuffFreq::ClientBase = 2049;
$HuffFreq::TeamBase = -2;
$HuffFreq::DamageBase = -2;

function Huff::PackIndexed( %idx, %base ) {
	$Huff::WriteString = $Huff::WriteString @ String::char( $HuffFreq::String, %idx - %base );
}

function Huff::UnpackIndexed( %base ) {
	%chr = String::char( $Huff::ReadString, $Huff::Idx );
	%idx = String::findSubStr( $HuffFreq::String, %chr );
	$Huff::Idx++;
	return ( %idx + %base );
}

function Huff::PackClient( %cl ) { Huff::PackIndexed( %cl, $HuffFreq::ClientBase ); }
function Huff::PackTeam( %team ) { Huff::PackIndexed( %team, $HuffFreq::TeamBase ); }
function Huff::PackDamageType( %type ) { Huff::PackIndexed( %type, $HuffFreq::DamageBase ); }

function Huff::UnpackClient() {	return ( Huff::UnpackIndexed( $HuffFreq::ClientBase ) ); }
function Huff::UnpackTeam() { return ( Huff::UnpackIndexed( $HuffFreq::TeamBase ) ); }
function Huff::UnpackDamageType() { return ( Huff::UnpackIndexed( $HuffFreq::DamageBase ) ); }
